﻿// create compact data
var saveData = {};
saveData.format = 2;		// specify "compact" file format
saveData.width = DATA.map.width;
saveData.height = DATA.map.height;
saveData.chipset = DATA.map.chipset;
// layers
saveData.layers = [];
for(var L=0; L<DATA.map.layers.length; L++)
{
	var layerString = "_";		// prevents XML reader from seeing this as a HUGE number
	for(var xx=0; xx<DATA.map.width; xx++)
	{
		for(var yy=0; yy<DATA.map.height; yy++)
		{
			var thisData = DATA.map.layers[L][xx][yy];
			var thisString = thisData.toString( 36 );
			// add padding if neccessary
			if(thisString.length==1){
				thisString = "0"+thisString;
			}// if:  string is too short
			layerString += thisString;		// append the data
		}// for:  height
	}// for:  width
	saveData.layers.push( layerString );
}// for:  layers
// collision
var collisionString = "_";		// prevents XML reader from seeing this as a HUGE number
for(var xx=0; xx<DATA.map.width; xx++)
{
	for(var yy=0; yy<DATA.map.height; yy++)
	{
		var thisData = DATA.map.collision[xx][yy];
		var thisString = thisData.toString( 36 );
		collisionString += thisString;		// append the data
	}// for:  height
}// for:  width
saveData.collision = collisionString;





// convert data to XML
XML.prototype.ignoreWhite = true;
var saveXml = new XML();
writeXml( saveData, saveXml, "map" );
System.setClipboard( saveXml );		// dump map data into clipboard for reliable saving
mdm.Dialogs.prompt("The map data has been copied to the clipboard.");
